/*
 * 2nd - OMAP "second stage" tt-Loader
 *
 * Copyright (C) 2008 Guillaume Bougard <gbougard@pkg.fr>
 * Copyright (C) 2005 Luis Recuerda <lrec@helios.homeip.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#include "types.h"

#ifndef _CONFIG_H_
#define _CONFIG_H_

// Default address in SRAM
#define CFG_LOADADDR			0x20000400

// Address to find jtag id, to check on which target we are running
#define OMAP_PRODUCTION_ID_1	0xfffe2004
#define OMAP32_ID_1				0xfffed404

// Extracted & adapted from linux sources: linux-2.6.24.3/include/asm-arm/arch-omap/io.h
#define omap_readb(a)		(*(volatile u8    *)(a))
#define omap_readw(a)		(*(volatile u16   *)(a))
#define omap_readl(a)		(*(volatile u32   *)(a))

#define omap_writeb(v,a)	(*(volatile u8    *)(a) = (v))
#define omap_writew(v,a)	(*(volatile u16   *)(a) = (v))
#define omap_writel(v,a)	(*(volatile u32   *)(a) = (v))

#endif
