/*
 * 2nd - OMAP "second stage" tt-loader
 *
 * Copyright (C) 2008 Guillaume Bougard <gbougard@pkg.fr>
 * Copyright (C) 2005 Luis Recuerda <lrec@helios.homeip.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

.equ WATCHDOG_VAL1, 0xf5
.equ WATCHDOG_VAL2, 0xa0

	.code 32

_vectors:

	.extern bend

.word	_start-_vectors
.word	bend-_start
.word	0, 0, 0
.word	0x00444e32
.word	0, 0
.word	0xffffffff
.word	0xffffffff
.word	0xffffffff
.word	0xffffffff
.word	0xffffffff
.word	0xffffffff
.word	0xffffffff
.word	0xffffffff

	.global	_start
_start:
	/*
	 * set the cpu to SVC32 mode as in x-load
	 */
	mrs r0, cpsr
	bic r0, r0, #0x1f
	orr r0, r0, #0xd3
	msr cpsr, r0

	// Turn off the watchdog during init...
	ldr r0, REG_WDT_TIMER_MODE
	mov r1, #WATCHDOG_VAL1
	str r1, [r0]
	mov r1, #WATCHDOG_VAL2
	str r1, [r0]

	// Mask all IRQs by setting all bits in the INTMR default
	mov r1, #0xffffffff
	ldr r0, REG_IHL1_MIR
	str r1, [r0]
	ldr r0, REG_IHL2_MIR
	str r1, [r0]

	// flush v4 I/D caches
	mov r0, #0
	mcr p15, 0, r0, c7, c7, 0   // flush v3/v4 cache
	mcr p15, 0, r0, c8, c7, 0   // flush v4 TLB

	// disable MMU stuff and caches
	mrc p15, 0, r0, c1, c0, 0
	bic r0, r0, #0x00002300     // clear bits 13, 9:8 (--V- --RS)
	bic r0, r0, #0x00000087     // clear bits 7, 2:0 (B--- -CAM)
	orr r0, r0, #0x00000002     // set bit 2 (A) Align
	orr r0, r0, #0x00001000     // set bit 12 (I) I-Cache
	mcr p15, 0, r0, c1, c0, 0

	ldr r0, REG_WSPR
	ldr r1, WSPR_VAL1
	str r1, [r0]
	ldr	r2, REG_WWPS

watch1Wait:
	ldr	r1, [r2]
	tst	r1, #0x10
	bne	watch1Wait

	ldr r1, WSPR_VAL2
	str r1, [r0]
watch2Wait:
	ldr r1, [r2]
	tst r1, #0x10
	bne watch2Wait

	ldr sp, _stack

	.extern _main
	bl _main
	ldr pc, [r0]			// Branch to content of mem returned as boot command


WSPR_VAL1:
	.word 0x0000aaaa
WSPR_VAL2:
	.word 0x00005555

REG_IHL1_MIR:                   // 32 bits
	.word 0xfffecb04
REG_IHL2_MIR:                   // 32 bits
	.word 0xfffe0004
REG_WDT_TIMER_MODE:				// 16 bits
	.word 0xfffec808
REG_WSPR:
	.word 0xfffeb048
REG_WWPS:
	.word 0xfffeb034

_stack:
	.word	0x2000F000
