#! /bin/sh

SSH_PORT=2222

MAKE_FLAGS="-DTWINTACT"
[ -n "${SSH_PORT}" ] && MAKE_FLAGS="${MAKE_FLAGS} -D'DROPBEAR_DEFPORT=\"${SSH_PORT}\"'"
[ "$1" == 'trace' ] && MAKE_FLAGS="${MAKE_FLAGS} -DDEBUG_TRACE"

source versions.sh
source environnement-de-cross-compilation.sh

cd ${DROPBEAR_BAS}-tt

# Configurer dropbear si le Makefile n'y est pas
if [ ! -e Makefile -o "$1" == 'trace' ]; then
	./configure --host=$PLATEFORME \
		--disable-shadow --disable-lastlog --disable-utmp --disable-utmpx \
		--disable-wtmp --disable-wtmpx --disable-pam --disable-zlib \
		--sysconfdir=/usr/share/config
	
	make clean
fi

# Compiler dropbear en statique et en mode multi
make strip PROGRAMS="dropbear dbclient dropbearkey scp" MULTI=1 STATIC=1 SCPPROGRESS=0 \
	CPPFLAGS="${MAKE_FLAGS}"

# Utiliser upx pour compresser le binaire si disponible
[ -e dropbearmulti -a "$1" != 'trace' ] && upx --version >/dev/null 2>&1 && upx dropbearmulti
