#! /bin/bash

source versions.sh
source environnement_de_cross_compilation.sh

for a in $ARCHIVES
do
	eval bas="\${${a}_BAS}"
	
	if [ ! -d "$bas" ]; then
		echo "Impossible de créer un patch si le dossier '$bas' n'existe pas"
		exit 1
	fi
	
	if [ ! -d "$bas-tt" ]; then
		echo "Impossible de créer un patch pour $bas si le dossier '$bas-tt' n'existe pas"
		echo "C'est ce dossier qui doit contenir la version modifiée de $bas"
		echo
		continue
	fi
	
	if [ -e "patchs/$bas.patch" ]; then
		echo "Sauvegarde du patch patchs/$bas.patch en patchs/$bas.patch.bak"
		mv -vf patchs/$bas.patch patchs/$bas.patch.bak
	fi
	
	if [ -e "patchs/$bas.clean.sh" ]; then
		echo "Nettoyage de l'environnement de compilation $bas-tt"
		cd $bas-tt
		source "../patchs/$bas.clean.sh"
		cd ..
	fi
	
	#  --ignore-blank-lines ?
	diff -Naurw $bas $bas-tt >patchs/$bas.patch
done
