#! /bin/bash

source versions.sh

for a in $ARCHIVES
do
	eval tar="\${${a}_TAR}"
	eval sha="\${${a}_SHA}"
	eval bas="\${${a}_BAS}"
	
	if [ -e "archives/$tar" ]; then
		chk="$(sha1sum archives/$tar|cut -d' ' -f1)"
		if [ "$chk" == "$sha" ]; then
			echo "L'archive $tar est disponible"
		else
			echo "L'archive $tar est présente mais semble être corrompue..."
			echo "SHA1 du fichier local: $chk"
			echo "Empreinte SHA1 attendue: $sha"
			echo
			echo "Effacez le fichier '$PWD/archives/$tar' et lancez le téléchargement"
			exit 1
		fi
	fi
	
	# Effacer le dossier local si nécessaire
	if [ -d "$bas" ]; then
		echo "L'archive $tar semble être déjà décompressée"
	else
	
		# Contrôle de l'option à utiliser pour tar
		Z='z'
		[ "${tar/tar.bz2}" == "$tar" ] || Z='j'
	
		echo "Décompression de archives/$tar"
		tar x${Z}f archives/$tar
	fi
	
	if [ -e "patchs/$bas.patch" ]; then
		# Contrôler le dossier local de travail
		[ -d "$bas-tt.bak" ] && rm -rf "$bas-tt.bak"
		[ -d "$bas-tt" ]     && mv -vf "$bas-tt" "$bas-tt.bak"
		
		echo "Copie du package $bas dans $bas-tt"
		cp -a $bas $bas-tt
		cd $bas-tt
		echo "Application du patch patchs/$bas.patch sur $bas-tt"
		patch -p1 <../patchs/$bas.patch
		cd ..
	fi
	
	if [ -e "patchs/$bas.config" ]; then
		echo "Copie de la configuration patchs/$bas.config dans $bas"
		cp -a "patchs/$bas.config" "$bas/.config"
	fi
	
done
