#! /bin/bash

source versions.sh

[ -d archives ] || mkdir archives
cd archives

for a in $ARCHIVES
do
	eval tar="\${${a}_TAR}"
	eval url="\${${a}_URL}"
	eval sha="\${${a}_SHA}"
	
	if [ -e "$tar" ]; then
		chk="$(sha1sum $tar|cut -d' ' -f1)"
		if [ "$chk" == "$sha" ]; then
			echo "L'archive $tar est déjà présente"
			continue
		else
			echo "L'archive $tar est déjà présente mais semble être corrompue..."
			echo "SHA1 du fichier local: $chk"
			echo "Empreinte SHA1 attendue: $sha"
			echo
			echo "Effacez le fichier '$PWD/$tar' et recommencez le téléchargement"
			exit 1
		fi
	fi
	
	# Télécharger l'archive
	wget -nd "${url}/${tar}"
	
	chk="$(sha1sum $tar|cut -d' ' -f1)"
	if [ "$chk" == "$sha" ]; then
		echo "L'empreinte SHA1 de l'archive téléchargée est correcte"
	else
		echo "ATTENTION ! L'archive '$PWD/$tar' semble corrompue"
		exit 2
	fi
done
