#! /usr/share/bin/busybox ash

die () {
	echo "Erreur: $*" >&2
	exit 1
}

# Initialisation de commandes utilisées dans ce script
BB='/usr/share/bin/busybox'
LS="$BB ls"
CUT="$BB cut"
SED="$BB sed"
STRIP="$SED -r -e 's/^[\\t ]+//' -e 's/[\[ ]+/ /g'"
TR="$BB tr"
GREP="$BB grep"
RM="$BB rm -f"
MV="$BB mv -f"
CHMOD="$BB chmod"
DROPBEARKEY="/usr/share/bin/dropbearkey -t dss"

cd /usr/share/bin || die "Binaires tt-tools non disponible"
[ -x busybox ] || die "Binaire busybox non disponible"
[ -x dropbearmulti ] || die "Binaire dropbear non disponible"

# A. Création des liens vers busybox
echo "Mise à jour des liens pour Busybox"

# Le cas des lien pour '[' & '[[' ne passe pas dans la moulinette automatique
ln -sf busybox [
ln -sf busybox [[

# On récupère l'i-node de busybox pour simplifier le filtrage
bbi="$($LS -i busybox | eval $STRIP | $CUT -d ' ' -f1)"
bbloGREP="$GREP -E \"^[ ]+$bbi \""

# On récupère la liste des liens existants en gardant des espaces aux extrémités
# de la chaine pour faciliter la suppression des liens utiles en exploitant
# les propriétés d'extractions de 'chemin' dans les variables
bblo="$($LS -iLw0 | eval $bbloGREP | $GREP -v busybox | eval $STRIP | $CUT -d ' ' -f2)"
bblo=" $(echo -n $bblo) "

# On récupère la liste des liens à avoir
bbll="$($BB | $GREP ',' | $GREP -v Copyright | $TR ',' ' ' | eval $STRIP)"

let lmax=40 lf=lmax
for lien in $bbll
do
	l=$lien
	[ "$l" == '[' ] && l='\[' || [ "$l" == '[[' ] && l='\[\['
	loA="${bblo% $l *}"
	if [ "$bblo" != "$loA" ]; then
		echo -n .
		# Le lien existe, on le supprime de la liste locale
		bblo="$loA ${bblo#* $l }"
	else
		echo -n '*'
		# On crée le lien nécessaire
		ln -sf busybox $lien
	fi
	let lf=--lf?lf:lmax ; [ "$lf" -eq "$lmax" ] && echo
done
echo

# Enfin, on supprime les liens qui ne sont plus à utiliser s'il en existe
if [ -n "$(echo -n $bblo)" ]; then
	echo "Supression des liens inutiles: $(echo $bblo)"
	$RM -f $bblo
fi

echo "Installation de busybox terminée"
echo

# B. On installe dropbear si nécessaire
# B.1. On installe les liens
for lien in dropbear dbclient dropbearkey scp
do
	ln -sf dropbearmulti $lien
done

# B.2. On contrôle s'il faut installer la configuration par défaut
cd /usr/share/config/dropbear || die "Configuration de dropbear non disponible"
for conf in authorized_keys motd shell
do
	# On supprime si la conf est déjà installée, sinon on l'installe
	[ -e "$conf" ] && $RM "$conf.majtmp" || $MV "$conf.majtmp" "$conf"
done

# B.3. On crée une clé privée si elle n'existe pas
[ -e dropbear_dss_host_key ] || $DROPBEARKEY dropbear_dss_host_key

# B.4. On mets à jour les droits
$CHMOD 600 authorized_keys dropbear_dss_host_key
$CHMOD 755 shell

echo "Installation de dropbear terminée"
echo
