#! /bin/sh

source versions.sh

archive_tools="release/tt-tools-${TT_TOOLS_VERSIONS}.tar.gz"
archive_twint="release/tt-tools-${TT_TOOLS_VERSIONS}-on-tt.tar.gz"

# Garde une copie des archives existantes
[ -e "$archive_tools" ] && mv -vf  "$archive_tools" "$archive_tools.old"
[ -e "$archive_twint" ] && mv -vf  "$archive_twint" "$archive_twint.old"

# Récupére les derniers binaires compilés si disponibles
for file in ${BUSYBOX_BAS}/busybox ${DROPBEAR_BAS}-tt/dropbearmulti
do
	[ ! -e "$file" ] && continue
	bin="${file/.*\/}"
	# Ne pas copier le binaire s'il n'est pas plus récent
	[ "bin/$bin" -ot "$file" ] || continue
	cp -vf $file bin
done

# Crée une archive pour les fichiers utiles à la cross-compilation
tar czf "$archive_tools" compile-busybox.sh compile-dropbear.sh creer-patchs.sh \
	dossiers-de-cross-compilation.sh generer-archive.sh versions.sh \
	environnement-de-cross-compilation.sh telecharge.sh ChangeLog LisezMoi.txt \
	patchs/${DROPBEAR_BAS}.patch patchs/${DROPBEAR_BAS}.clean.sh \
	patchs/${BUSYBOX_BAS}.clean.sh patchs/${BUSYBOX_BAS}.config \
	bin/twintact-udev udev/twintact.rules bin/synchro_net.sh \
	&& echo "Archive $archive_tools créée"

# Crée une archive pour être directement téléchargée sur le twintact
tar czf "$archive_twint" bin/dropbearmulti bin/busybox \
	config/dropbear/shell.majtmp config/dropbear/motd.majtmp \
	config/dropbear/authorized_keys.majtmp bin/maj-tt-tools.sh \
	&& echo "Archive $archive_twint créée"
