#! /bin/sh

SSH="ssh -p ${TWINTACT_PORT} -i ${TWINTACT_SHARE}/id_dsa root@twintact"

# Mettre à jour l'heure sur le TwinTact si trop différente de l'heure de l'hôte
# Par exemple après un long arrêt du TwinTact
TTTIME=$($SSH date +%s)
MYTIME=$(date +%s)
let DIFFTIME=MYTIME-TTTIME
logger -i -p kern.debug -t TwinTact "Horloge TwinTact DIFFTIME=${DIFFTIME}"
if [ "${DIFFTIME/-}" -gt 10000 ]; then
	$SSH date -s `date +%m%d%H%M%Y.%S`
	logger -i -p kern.info -t TwinTact "Horloge TwinTact synchronisée"
fi

# Ajout d'une route par défaut au réseau du TT pour utiliser le PC comme passerelle
# Sortir aussi l'état de la table de routage en cas de débogage
echo "route add -net 0.0.0.0 gw ${TWINTACT_BIND} ; route -n " | $SSH ash -s
logger -i -p kern.info -t TwinTact "Routage sur TwinTact à jour"

# Eventuellement utiliser un scrip perso si ça peut être utile
# Par exemple peut être utilisé pour activer un syslog renvoyant le log système sur
# la machine cette machine
[ -x "${TWINTACT_SHARE}/synchro_net_perso.sh" ] && \
	. "${TWINTACT_SHARE}/synchro_net_perso.sh"
